﻿var editTaskSchedule = {
    context: $(".v-editTaskSchedule"),
    projectId: 0,
    initialize: function () {
        editTaskSchedule.projectId = $("#ProjectId", this.context).val() || 0;
        editTaskSchedule.setRecurTypeContent($("#RecurrenceType", this.context).val());

        $("#TaskName", editTaskSchedule.context).a4autocomplete({
            ajaxAction: a4.getAction("GetProjectTasksForAutocomplete", "Home", "Project"),
            ajaxParams: { projectId: editTaskSchedule.projectId, type: 2 },
            valueProperty: "Id",
            labelProperty: "Title",
            altValueField: $("#TaskId")
        });

        $("#ProjectName", editTaskSchedule.context).a4autocomplete({
            ajaxAction: a4.getAction("GetProjectsForAutocomplete", "TaskSchedules", "Project"),
            valueProperty: "Id",
            labelProperty: "Name",
            categoryProperty: "FolderName",
            altValueField: $("#ProjectId"),
            select: function (event, data)
            {
                editTaskSchedule.projectId = data && data.item ? data.item.Id : 0;
                editTaskSchedule.validateTaskNameAutocomplete();

                if (editTaskSchedule.projectId != 0)
                {
                    $("#TaskName", editTaskSchedule.context).val("");

                    $("#TaskName", editTaskSchedule.context).a4autocomplete({
                        ajaxParams: { projectId: editTaskSchedule.projectId, type: 2 }
                    });
                }
            }
        });

        editTaskSchedule.validateTaskNameAutocomplete();

        a4.setInputFocus(this.context);
        $(".h-autonumeric", this.context).autoNumeric();

        var startDate = $("#StartDateTime", editTaskSchedule.context);
        var endDate = $("#EndDateTime", editTaskSchedule.context);

        startDate.datetimepicker({
            maxDate: endDate.val(),
            onClose: function () {
                var minDate = $(this).val();
                endDate.datepicker("option", "minDate", new Date(minDate));
            }
        });

        endDate.datetimepicker({
            minDate: startDate.val(),
            onClose: function () {
                var maxDate = $(this).val();
                startDate.datepicker("option", "maxDate", maxDate);
            }
        });
    },
    validateTaskNameAutocomplete: function () {
        // disable task name autocomplete if projectId is not exists
        if (editTaskSchedule.projectId == 0)
        {
            $("#TaskName", editTaskSchedule.context).val("");
            $("#TaskName", editTaskSchedule.context).a4autocomplete("disable");
        }
        else
        {
            $("#TaskName", editTaskSchedule.context).a4autocomplete("enable");
        }
    },
    setRecurTypeContent: function (recurType) {
        switch (recurType)
        {
            case "OneTime":
                $(".v-endDateTimeSection", this.context).hide();
                $(".recurbydaysection", this.context).hide();
                $(".recurbyweeksection", this.context).hide();
                $(".recurbymonthsection", this.context).hide();
                break;

            case "RecurByDay":
                $(".v-endDateTimeSection", this.context).show();
                $(".recurbydaysection", this.context).show();
                $(".recurbyweeksection", this.context).hide();
                $(".recurbymonthsection", this.context).hide();
                break;

            case "RecurByWeek":
                $(".v-endDateTimeSection", this.context).show();
                $(".recurbydaysection", this.context).hide();
                $(".recurbyweeksection", this.context).show();
                $(".recurbymonthsection", this.context).hide();
                break;

            case "RecurByMonth":
                $(".v-endDateTimeSection", this.context).show();
                $(".recurbydaysection", this.context).hide();
                $(".recurbyweeksection", this.context).hide();
                $(".recurbymonthsection", this.context).show();
                break;

            default:
        }
    },
    bindEvents: function () {
        editTaskSchedule.context.on("change", "#RecurrenceType", function () {
            editTaskSchedule.setRecurTypeContent($("#RecurrenceType", this.context).val());
        });

        editTaskSchedule.context.on("click", "#DisableEndDateTime", function () {
            if ($(this).is(':checked'))
                $("#EndDateTime", editTaskSchedule.context).attr("disabled", "disabled").prop("disabled", true);
            else
                $("#EndDateTime", editTaskSchedule.context).removeAttr("disabled").prop("disabled", false);
        });
    }
};

$(document).ready(function () {
    if (editTaskSchedule.context.length > 0)
    {
        editTaskSchedule.initialize();
        editTaskSchedule.bindEvents();
    }
});